/*
 * Decompiled with CFR 0.152.
 */
package frc.emul.util;

import frc.emul.api.IEditableMemory;
import frc.emul.api.IMemory;
import frc.emul.api.MemoryAccessException;
import frc.emul.api.MemoryType;
import frc.emul.api.persistence.IPersistenceReader;
import frc.emul.api.persistence.IPersistenceWriter;
import frc.emul.api.persistence.PersistenceException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Random;

public class RawMemory
implements IMemory,
IEditableMemory {
    private final MemoryType type;
    private boolean canWrite;
    private final boolean canExec;
    private final boolean bigI;
    private final boolean wrapped;
    private final int base;
    protected byte[] buff;
    private int loadedSize;
    private boolean reportFaultyWrites = false;

    public RawMemory(String string, int n, int n2, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        this(MemoryType.OTHER, n, n2, bl, bl2, bl3, bl4);
    }

    public RawMemory(MemoryType memoryType, int n, int n2, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        this.type = memoryType;
        this.buff = new byte[n2];
        this.bigI = bl2;
        this.wrapped = bl;
        this.canWrite = bl3;
        this.canExec = bl4;
        this.base = n;
    }

    public void peek(byte[] byArray, int n, int n2, int n3) {
        System.arraycopy(this.buff, n, byArray, n2, n3);
    }

    public void poke(byte[] byArray, int n, int n2, int n3) {
        System.arraycopy(byArray, n, this.buff, n2, n3);
    }

    public MemoryType getType() {
        return this.type;
    }

    public int getSize() {
        return this.buff.length;
    }

    public int getLoadedSize() {
        return this.loadedSize;
    }

    public int getFirstAddress() {
        return this.base;
    }

    public int getLastAddress() {
        return this.base + this.buff.length - 1;
    }

    public boolean isValidArea(int n, int n2) {
        if (this.wrapped) {
            return true;
        }
        return (n -= this.base) + n2 <= this.buff.length;
    }

    public boolean canRead(int n, int n2) {
        return this.isValidArea(n, n2);
    }

    public boolean canWrite(int n, int n2) {
        return this.canWrite && this.isValidArea(n, n2);
    }

    public boolean canExecute(int n, int n2) {
        return this.canExec && this.isValidArea(n, n2);
    }

    public int readS8(int n) {
        return this.get(this.debase(n));
    }

    public int readU8(int n) {
        return 0xFF & this.get(this.debase(n));
    }

    public void write8(int n, int n2) {
        if (this.canWrite(n, 1)) {
            this.set(this.debase(n), n2);
        } else if (this.reportFaultyWrites) {
            throw new MemoryAccessException(n, null, true, n2);
        }
    }

    public int readS16(int n) {
        n = this.debase(n);
        if (this.bigI) {
            return this.get(n) << 8 | 0xFF & this.get(n + 1);
        }
        return this.get(n + 1) << 8 | 0xFF & this.get(n);
    }

    public int readU16(int n) {
        n = this.debase(n);
        if (this.bigI) {
            return (0xFF & this.get(n)) << 8 | 0xFF & this.get(n + 1);
        }
        return (0xFF & this.get(n + 1)) << 8 | 0xFF & this.get(n);
    }

    public void write16(int n, int n2) {
        if (this.canWrite(n, 2)) {
            n = this.debase(n);
            if (this.bigI) {
                this.set(n, n2 >> 8);
                this.set(n + 1, n2);
            } else {
                this.set(n, n2);
                this.set(n + 1, n2 >> 8);
            }
        } else if (this.reportFaultyWrites) {
            throw new MemoryAccessException(n, null, false, n2);
        }
    }

    public void fill(byte by) {
        Arrays.fill(this.buff, by);
    }

    public void randomize() {
        long l = new Random().nextLong();
        System.out.println("Random seed = " + l);
        new Random(l).nextBytes(this.buff);
    }

    public final boolean save(OutputStream outputStream, boolean bl) throws IOException {
        return this.dump(outputStream);
    }

    public boolean dump(OutputStream outputStream) throws IOException {
        outputStream.write(this.buff);
        return true;
    }

    public final boolean load(InputStream inputStream, boolean bl) throws IOException {
        this.loadedSize = -1;
        return this.loadRaw(inputStream);
    }

    public boolean feed(byte[] byArray, int n, int n2, int n3) {
        if (this.canWrite(n2, n3)) {
            n2 = this.debase(n2);
            System.arraycopy(byArray, n, this.buff, n2, n3);
            return true;
        }
        return false;
    }

    public void store(IPersistenceWriter iPersistenceWriter) throws PersistenceException {
        iPersistenceWriter.write(this.buff, 0, this.getSize());
    }

    public void load(IPersistenceReader iPersistenceReader) throws PersistenceException {
        iPersistenceReader.read(this.buff, 0, this.getSize());
    }

    protected boolean loadRaw(InputStream inputStream) throws IOException {
        this.loadedSize = inputStream.read(this.buff);
        return true;
    }

    protected void setWritable(boolean bl) {
        this.canWrite = bl;
    }

    private final int debase(int n) {
        return (n & Integer.MAX_VALUE) - this.base;
    }

    private final int get(int n) {
        return this.wrapped ? this.buff[n % this.buff.length] : this.buff[n];
    }

    private final void set(int n, int n2) {
        if (this.wrapped) {
            this.buff[n % this.buff.length] = (byte)n2;
        } else {
            this.buff[n] = (byte)n2;
        }
    }
}

